# -*- coding: utf-8 -*-
'''
Created 16-Jan-2025
See VersionInfo in __main__ for current update
'''

from MSPyBentley import *
#from MSPyBentleyGeom import *
#from MSPyECObjects import *
from MSPyDgnPlatform import *
from MSPyMstnPlatform import *

MS_REPORT_OUTPUT = str('MS_REPORT_OUTPUT')
MS_TABLE_INPUT = str('MS_TABLE_INPUT')

def GetInputFolder()->(bool, str):
    '''
    Directory containing files to be used as data sources (MS_TABLE_INPUT).
    This is the same folder as GetTableInputFolder() below.
    If not found, returns a folder in the temp directory.
    MicroStation defines no other generally useful input variable.
    Feel free to define your own in your MicroStation workspace.
    Returns: tuple (valid, path)    
    '''
    path = WString()    
    status = ConfigurationManager.GetVariable(path, MS_TABLE_INPUT)
    if BentleyStatus.eSUCCESS == status:
        return (True, str(path))
    status = ConfigurationManager.GetLocalTempDirectory (path,"")
    if BentleyStatus.eSUCCESS == status:
        return (True, str(path))
        
    return (False, "")

def GetTableInputFolder()->(bool, str):
    '''
    Directory containing Excel workbooks and CSV files to be used as data sources for tables (MS_TABLE_INPUT).
    If not found, returns a folder in the temp directory.
    Returns: tuple (valid, path)    
    '''
    path = WString()    
    status = ConfigurationManager.GetVariable(path, MS_TABLE_INPUT)
    if BentleyStatus.eSUCCESS == status:
        return (True, str(path))
    status = ConfigurationManager.GetLocalTempDirectory (path,"")
    if BentleyStatus.eSUCCESS == status:
        return (True, str(path))
        
    return (False, "")

def GetReportFolder ()->(bool, str):
    '''
    Get a folder where a report file may be written.  
    If configuration variable MS_REPORT_OUTPUT is defined, it gets that path.
    Otherwise, it returns a folder in the operating system TEMP directory.
    Returns: tuple (valid, path)    
    '''
    path = WString()    
    
    status = ConfigurationManager.GetVariable(path, MS_REPORT_OUTPUT)
    if BentleyStatus.eSUCCESS == status:
        return (True, str(path))
    status = ConfigurationManager.GetLocalTempDirectory (path,"")
    if BentleyStatus.eSUCCESS == status:
        return (True, str(path))
        
    return (False, "")

if __name__ == "__main__":  # check if this script is being run directly (not imported as a module)
    
    path = WString()
    valid = False
    (valid, path) = la_cfg.GetReportFolder()
    if valid:
        msg = f"CfgVar Tester report folder {MS_REPORT_OUTPUT}='{path}'"
        MessageCenter.ShowDebugMessage(msg, msg, False)
    else:
        msg = "Unable to get report folder"
        MessageCenter.ShowErrorMessage(msg, msg, False)
    
