# -*- coding: utf-8 -*-

'''
Place cells along line.

User should pick a line to follow, using the Pick button.
Clicking the Execute button places a named cell at specified intervals along that line.

Created 10-Mar-2025
This example is a Python version of the VBA Follow Line macro,
with the addition of a user interface.
https://www.la-solutions.org/CONNECT/MVBA/MVBA-FollowLine.htm

See also this discusion about stations
https://bentleysystems.service-now.com/community?id=community_question&sys_id=260669571be62a90dc6db99f034bcbda
'''

from MSPyBentley import *
from MSPyDgnPlatform import *    
from MSPyMstnPlatform import *
from FollowLine.follow_line_qt import *
from la_solutions.version_info import VersionInfo

def Version ():
    ''' Return the version of this app. '''
    return VersionInfo("Place Cells Along", 25, 8, 5, "Place cells along a line at a specified interval")

# Main entry point for the Follow Line app
if __name__ == "__main__":
    vinfo = Version() 
    MessageCenter.ShowInfoMessage(vinfo.brief, vinfo.verbose, False)
    # Start our user interface
    Window.Run(vinfo)
    