# -*- coding: utf-8 -*-

'''
Created 12-Mar-2025
# This example is a test module for an XML command table.
'''
from os import *
from pathlib import Path

from MSPyBentley import *
from MSPyMstnPlatform import *
from la_solutions.file_utilities import *
from la_solutions.version_info import *
# Imports from CommandTableTester folder
# Decide what you want to test, then choose the appropriate 'bad' command table by removing the comment #

def cmdTest1():
    KEY_IN = "COMMANDTEST TEST1"
    ''' Called by MicroStation's input parser in response to  KEY_IN.'''
    cmdName = "cmdTest1"
    MessageCenter.ShowDebugMessage(cmdName, f"{cmdName} responds to key-in {KEY_IN} ", False) 
    
def cmdTest2Arg2():
    ''' Called by MicroStation's input parser in response to  KEY_IN.'''
    KEY_IN = "COMMANDTEST TEST2 ARG2"
    cmdName = "cmdTest2Arg2"
    MessageCenter.ShowDebugMessage(cmdName, f"{cmdName} queues key-in {KEY_IN} ", False)    
    
def Version ():
    ''' Return the version of this module. '''
    return VersionInfo("Command Table Tester", 25, 3, 18, "Test the syntax of an XML command table")
    
if __name__ == "__main__":  # check if this script is being run directly (not imported as a module)
    
    handler = CommandTableHandler()
    handler.LoadCommandTable(__file__)
    MessageCenter.ShowDebugMessage("LoadCommandTableFromXml '{handler.XmlCommandTable}'", f"{WString (__file__)} ", False)
