# -*- coding: utf-8 -*-

'''
Utilities for working with selection sets.
Created 06-Feb-2025
'''

from MSPyBentley import *
from MSPyBentleyGeom import DPoint3d, DPoint2d, ICurvePrimitive
from MSPyDgnPlatform import *
from MSPyMstnPlatform import *
from MSPyDgnView import SelectionSetManager
from typing import Union

from la_solutions.version_info import VersionInfo

def ElementIsSelected ()->tuple[bool, ElementHandle]:
    '''
    Shows how to get an element from a selection set.
    If user has selected at least one element, get its ElementHandle.
    Returns: tuple(True, ElementHandle) if an element is found.
    '''
    valid = False
    msg = str()
    eh = ElementHandle()
    ssm : SelectionSetManager = SelectionSetManager.GetManager()
    if ssm.IsActive():    
        #   Get the first element in the selection
        status = ssm.GetElement(0, eh)
        if (status == BentleyStatus.eSUCCESS):
            valid = eh.IsValid()
        else:
            msg = "Failed to get element from selection set"
            MessageCenter.ShowErrorMessage(msg, msg, False)
    else:
        msg = "Nothing is selected"
        MessageCenter.ShowErrorMessage(msg, msg, False)
        valid = False
    return (valid, eh)      
    
#main
if __name__ == "__main__":
    vinfo = VersionInfo("Selection Set", 25, 2, 6, "Selection Set Utilities")
    MessageCenter.ShowInfoMessage(vinfo.brief, vinfo.verbose, False)

    valid, elementHandle = ElementIsSelected()
    if valid:
        msg = GetElementDescription(elementHandle)
        MessageCenter.ShowInfoMessage(msg, msg, False)
