import sys
import os
from pathlib import Path
from MSPyMstnPlatform import MessageCenter

def getScriptFolder ()->str:
    """Get the folder that contains this Python script"""
    return os.path.join(os.path.dirname(__file__))

def getFileFromScriptSiblingFolder (fileName: str, subFolder: str)->str:   
    """Get a fully-qualified file path for a file in a sibling folder of this script's folder"""
    projectFolder = Path(getScriptFolder()).parent
    subFolderPath = os.path.abspath(os.path.join(projectFolder, subFolder))
    filePath = os.path.join(subFolderPath, fileName)
    #msg = f"getFileFromScriptSubFolder fileName '{fileName}' "
    #MessageCenter.ShowDebugMessage(msg, filePath, False)
    if os.path.isfile(filePath):
        #msg = f"Found file '{filePath}'"
        #MessageCenter.ShowDebugMessage(msg, filePath, False)
        return filePath
    else:
        #   Advise user that the file name is incorrect
        brief = f"File '{fileName}' does not exist"
        verbose = f"File '{filePath}' does not exist"
        #   These messages are displayed in MicroStation's Message Center
        MessageCenter.ShowErrorMessage (brief, verbose, False)
        return str()   
    
def getFileFromScriptFolder (fileName: str)->str:
    """Get a fully-qualified file path for a file in this script's folder"""
    filePath = os.path.join(getScriptFolder(), fileName)
    #msg = f"getFileFromScriptFolder fileName '{fileName}' "
    #MessageCenter.ShowDebugMessage(msg, filePath, False)
    if os.path.isfile(filePath):
        #msg = f"Found file '{filePath}'"
        #MessageCenter.ShowDebugMessage(msg, filePath, False)
        return filePath
    else:
        #   Advise user that the file name is incorrect
        brief = f"File '{fileName}' does not exist"
        verbose = f"File '{filePath}' does not exist"
        #   These messages are displayed in MicroStation's Message Center
        MessageCenter.ShowErrorMessage (brief, verbose, False)
        return str()   
        
