# -*- coding: utf-8 -*-
from os import *
from pathlib import Path
from MSPyBentley import *
from MSPyDgnPlatform import *
from MSPyDgnView import *
from MSPyMstnPlatform import *

from CommandTableTester.commands import *
from la_solutions.command_table_loader import *

#
# Command Table Tester example Python app.
#
# The purpose of this project is to provide pointers to debugging XML command tables.
# In the CommandTableTester folder you will find several example XML command tables, some good and some bad.
# They exist to test the codes returned. 
# You'll find the implementation .py files in CommandTableTester.commands
#

if __name__ == "__main__":  # check if this script is being run directly (not imported as a module)
    vinfo = Version()
    MessageCenter.ShowInfoMessage(vinfo.brief, vinfo.verbose, False)
    handler = CommandTableHandler()
    scriptPath = str(Path (os.path.dirname(__file__)) / 'CommandTableTester')
    #print (f"scriptPath '{scriptPath}'")
    
    # Load a good command table (default is 'commands.xml')
    #handler.LoadCommandTable(__file__, scriptPath)
    
    # Load a bad command table. Name matches error code in commands.py
    #handler.LoadCommandTable(__file__, scriptPath, "commands_XMLMISSINGROOTTABLE.xml")
    
    # Load a bad command table. Name matches error code in commands.py
    #handler.LoadCommandTable(__file__, scriptPath, "commands_XMLDUPLICATESUBTABLE.xml")
    
    # Load a bad command table. Name matches error code in commands.py
    #handler.LoadCommandTable(__file__, scriptPath, "commands_XMLMISSINGCOMMANDWORD.xml")
    
    # Load a bad command table. Name matches error code in commands.py
    #handler.LoadCommandTable(__file__, scriptPath, "commands_XMLDUPLICATEKEYINHANDLERSNODE.xml")
    
    # Load a bad command table. Name matches error code in commands.py
    #handler.LoadCommandTable(__file__, scriptPath, "commands_XMLMISSINGKEYINNODE.xml")
    
    # Load a bad command table. Name matches error code in commands.py
    #handler.LoadCommandTable(__file__, scriptPath, "commands_XMLMISSINGFUNCTIONNODE.xml")
    
    # Load a bad command table. Name matches error code in commands.py
    #handler.LoadCommandTable(__file__, scriptPath, "commands_NOCOMMANDMATCH.xml")
    
    # Load a bad command table. Name matches error code in commands.py
    handler.LoadCommandTable(__file__, scriptPath, "commands_AMBIGUOUSMATCH.xml")
