# -*- coding: utf-8 -*-

'''
Cell Library test.

Created 24-Jul-2025

'''

from MSPyBentley import *
from MSPyDgnPlatform import *    
from MSPyMstnPlatform import *
    
def GetActiveCellLibraryObject(lib_reference)->bool:
    ''' Get a reference to the active cell library.
    Returns: True if there is an active cell library. '''
    lib_name = BeFileName()
    Cell.GetLibraryName(lib_name)
    if lib_name.IsEmpty():
        return False
    else:
        (err_code, lib_reference) = Cell.GetLibraryObject(lib_name.GetWCharCP(), False)
        #print(f"err_code={err_code}")
        if err_code == 0 and lib_reference != None:
            #print(lib_reference)
            return True
        else:
            return False  

# Main entry point for the Cell Tester app
if __name__ == "__main__":
    ''' Pass an empty file name to GetLibraryName() to get the name of the active cell library.
    Returns an empty string if there is no currect cell library. '''
    lib_name = BeFileName()
    Cell.GetLibraryName(lib_name)
    if lib_name.IsEmpty():
        print("Cell Library name is empty")
    else:
        # Pass the cell library name to GetLibraryObject(), which 
        # returns a Python tuple(error_code, object_reference).
        # If the call succeeds then error_code == 0 (eSUCCESS) and
        # lib_reference is the cell library (*.cell file).
        (err_code, lib_reference) = Cell.GetLibraryObject(lib_name.GetWCharCP(), False)
        print(f"err_code={err_code}")
        if err_code == 0 and lib_reference != None:
            print(f"Found reference to cell library '{lib_name}'")
            print(lib_reference)
        else:
            print(f"Could not get reference to cell library '{lib_name}'")
    
        # The function GetActiveCellLibraryObject() wraps the above logic
        lib_reference = None
        if GetActiveCellLibraryObject(lib_reference):
            print(f"Found reference to active cell library")
        else:
            print(f"No active cell library")
