# -*- coding: utf-8 -*-

# Created 01-Apr-2025
# Updated 18-Apr-2025

from PyQt5 import QtCore
from PyQt5.QtWidgets import QMainWindow, QApplication
from PyQt5.QtCore import QTimer, Qt

from MSPyMstnPlatform import PyCadInputQueue

class WindowBase(QMainWindow):
    ''' This window inherits from PyQt QMainWindow. 
    
    Use as a base class for your app's Window. '''
    def __init__(self):
        super().__init__()
        # The Window ID may be useful when interacting with Microsoft Win32 API
        #self.storedWinId = self.winId()
       
    # This function was adapted from the delivered example QtClock.
    def start_message_pump_timer(self):
        _TICK = 1000 # milliseconds
        timer = QTimer()   # create a QTimer object 
        timer.timeout.connect(updateMstn)  # connect the timer's timeout signal to the updateMstn function
        timer.start(_TICK) # start the timer with an interval of _TICK milliseconds

def updateMstn ():
    ''' Called by the message pump timer. '''
    PyCadInputQueue.PythonMainLoop()
    
if __name__ == "__main__":  # check if this script is being run directly (not imported as a module)
    Run()
