import sys
import os
from MSPyMstnPlatform import MessageCenter

def dump(obj):
    """Print the properties of an object"""
    for attr in dir(obj):
        print("obj.%s = %r" % (attr, getattr(obj, attr)))

def get_script_folder ()->str:
    """Get the folder that contains this Python script."""
    return os.path.join(os.path.dirname(__file__))
    
def getFileFromScriptFolder (fileName: str)->str:
    """Get a fully-qualified file path for a file in this script's folder."""
    filePath = os.path.join(get_script_folder(), fileName)
    if os.path.isfile(filePath):
        return filePath
    else:
        #   Advise user that the file name is incorrect
        brief = f"File '{fileName}' does not exist"
        verbose = f"File '{filePath}' does not exist"
        #   These messages are displayed in MicroStation's Message Center
        MessageCenter.ShowErrorMessage (brief, verbose, False)
        return str()   
        
def get_icon_from_script_sub_folder (fileName: str)->str:
    """Get a fully-qualified file path for a file in this script's Icons sub-folder."""
    filePath = os.path.join(get_script_folder(), "Icons", fileName)
    if os.path.isfile(filePath):
        return filePath
    else:
        #   Advise user that the file name is incorrect
        brief = f"Icon '{fileName}' does not exist"
        verbose = f"Icon '{filePath}' does not exist"
        #   These messages are displayed in MicroStation's Message Center
        MessageCenter.ShowErrorMessage (brief, verbose, False)
        return str()   
        
