# -*- coding: utf-8 -*-

import sys
import PyQt5
from PyQt5 import QtCore, QtWidgets
from PyQt5.QtWidgets import *
from PyQt5.QtWidgets import QMainWindow, QApplication, QGridLayout
from PyQt5.QtCore import Qt
from PyQt5.QtGui import QFont, QWindow, QIcon
import time
#import win32api

import os
from MSPyBentley import *
from MSPyBentleyGeom import *
from MSPyECObjects import *
from MSPyDgnPlatform import *
from MSPyDgnView import *
from MSPyMstnPlatform import *
import webbrowser
import la_solutions_utilities  as la_utilities
#import la_solutions_qt_widgets as la_widgets 
from qt_window_base_class import *
from count_elements_by_type import *
from version_info import VersionInfo

#
# Hello World 4 with Menu Bar and MicroStation commands: example MicroStation Python app.
#
# This demonstrates a PyQt5 UX window containing a small number of user-interface widgets.
# This example defines a window base class (WindowBase in qt_window_base_class.py).  Its purpose is to own a timer that pumps windows messages
# so that MicroStation remains responsive.
#
# The MainWindow class inherits from that MainWindowBase class.  The base class starts the message pump, the
# MainWindow class owns the displayable widgets.
#
LBL_ELLIPSE_COUNT = 'lblEllipseCount'
LBL_LINE_COUNT = 'lblLineCount'

class MainWindow(WindowBase):
    
    # Initialize the main window class.
    # Edit the Version Info to suit your app and release date
    def __init__(self, versionInfo):
        # Call the parent class's constructor to initialize the main window
        super().__init__()
        self._versionInfo = versionInfo
        self.setWindowTitle(self._versionInfo.app_name)
        # MicroStation Message Centre shows a brief and a verbose message
        MessageCenter.ShowInfoMessage (f"About {self._versionInfo.app_name}", self._versionInfo.verbose, False)        
             
        def makeLabel (self)->QLabel:
            ''' Create a QLabel widget. '''
            label = QLabel(self, alignment=Qt.AlignmentFlag.AlignTop)
            label.setText(f"<h1>{self._versionInfo.app_name}</h1><h2>Try my menus!</h2>")  
            label.setStyleSheet('color: lightgrey')
            return label

        def makeLaSolutionsLabel (self)->QLabel:
            ''' Create an LA Solutions QLabel widget. '''
            label = QLabel(self, alignment=Qt.AlignmentFlag.AlignBottom)
            label.setText("<h3>LA Solutions</h3>")
            # Display the label using a style-sheet to obtain CSS font attributes
            label.setStyleSheet('color: teal; font-family: Times New Roman; font-size: 14pt')
            return label
        
        def makeVersionLabel (self)->QLabel:           
            ''' Create a version QLabel widget. '''
            label = QLabel(self, alignment=Qt.AlignmentFlag.AlignRight | Qt.AlignmentFlag.AlignBottom)
            label.setText(self._versionInfo.brief)
            return label
        
        def makeEllipseCountLabel (self)->QLabel:           
            ''' Create an ellipse count QLabel widget. '''
            label = QLabel(self, alignment=Qt.AlignmentFlag.AlignLeft | Qt.AlignmentFlag.AlignBottom)
            label.setText("Ellipse Count=")
            label.setObjectName(LBL_ELLIPSE_COUNT)
            return label
        
        def makeLineCountLabel (self)->QLabel:           
            ''' Create a line count QLabel widget. '''
            label = QLabel(self, alignment=Qt.AlignmentFlag.AlignLeft | Qt.AlignmentFlag.AlignBottom)
            label.setText("Line Count=")
            label.setObjectName(LBL_LINE_COUNT)
            return label
        
        def makeButton(self)->QPushButton:
            ''' Create a QPushButton widget. '''
            button = QPushButton("Press me for an About dialog!")
            button.clicked.connect(self.button_clicked)
            button.move(110,160)
            return button
        
        start_pos_x:    int = 100
        start_pos_y:    int = 200        
        width:          int = 420
        height:         int = 240
        # Set the size of the main window (x, y, width, height)
        self.setGeometry (
            start_pos_x,  # initial x-coordinate
            start_pos_y,  # initial y-coordinate
            width,  # width in pixels
            height   # height in pixels
        )
        # The window can be resized, but if you want a fixed size...
        #self.setFixedSize(width, height)

        iconPath = la_utilities.get_icon_from_script_sub_folder ('smiley-icon.png')
        #print(f"iconPath '{iconPath}'")
        self.setWindowIcon(QIcon(iconPath))
                
        # Make the main window stay on top of other windows.
        # Unfortunately the Qt window floats above other apps. as well as MicroStation
        self.setWindowFlags(
            QtCore.Qt.WindowStaysOnTopHint
        )        
        
        def make_action_exit (self):
            action = QAction(QIcon(f"{la_utilities.get_icon_from_script_sub_folder('exit-svgrepo-com.svg')}"), '&Exit', self)
            action.setShortcut('Ctrl+Q')
            action.setStatusTip('Exit application')
            action.triggered.connect(self.exitCall)
            return action
                    
        def make_action_help (self):
            action = QAction(QIcon(f"{la_utilities.get_icon_from_script_sub_folder('icons8-info-64.svg')}"), '&Documentation', self)        
            action.setShortcut('')
            action.setStatusTip('Help Documentation')
            action.triggered.connect(self.helpDocCall)     
            return action
        
        def make_action_count_ellipses (self):
            #action = QAction(QIcon(f"{la_utilities.getFileFromScriptFolder('icons8-mouse.svg')}"), 'Count &Ellipses', self)    
            action = QAction(QIcon(f"{la_utilities.get_icon_from_script_sub_folder('sigma-svgrepo-com.svg')}"), 'Count &Ellipses', self)    
            
            action.setShortcut('')
            action.setStatusTip('Count Ellipses')
            action.triggered.connect(self.count_ellipses_imp)   
            return action
                     
        def make_action_count_lines (self):
            #action = QAction(QIcon(f"{la_utilities.getFileFromScriptFolder('icons8-mouse.svg')}"), 'Count &Lines', self)        
            action = QAction(QIcon(f"{la_utilities.get_icon_from_script_sub_folder('sigma-svgrepo-com.svg')}"), 'Count &Lines', self)        
            action.setShortcut('')
            action.setStatusTip('Count Lines')
            action.triggered.connect(self.count_lines_imp)   
            return action
                     
        def makeMenuActions (self, fileMenu, countMenu, helpMenu):
            ''' A Qt menu requires an action.  When you invoke the action by choosing a menu item,
            Python reacts by calling the target of that action through the QAction.triggered.connect(target) call.
            
            In this small app, the action of File|Exit is the exitCall() function, and the 
            action of Help|Documentation is the helpDocCall() function. '''         
            # Create menu actions
            fileMenu.addAction(make_action_exit(self))
            countMenu.addAction(make_action_count_ellipses(self))
            countMenu.addAction(make_action_count_lines(self))
            helpMenu.addAction(make_action_help(self))

        def makeMenus(self):
            menuBar = self.menuBar()
            fileMenu = menuBar.addMenu('&File')
            countMenu = menuBar.addMenu('&Count Elements')
            helpMenu = menuBar.addMenu('&Help')
            # Add an action for each menu
            makeMenuActions (self, fileMenu, countMenu, helpMenu)

        # Create menu bar and add actions
        makeMenus (self)
        
        # Use a grid layout having 3 rows and 2 columns
        layout = QGridLayout()
        layout.addWidget(makeEllipseCountLabel(self), 0, 0)
        layout.addWidget(makeLineCountLabel(self), 1, 0)
        layout.addWidget(makeLaSolutionsLabel(self), 2, 0)
        layout.addWidget(makeVersionLabel(self), 2, 1)
        self.setEllipseCount(0)
        self.setLineCount(0)
        
        widget = QWidget()
        widget.setLayout(layout)
        self.setCentralWidget(widget)
        
        self.statusBar = QStatusBar()
        self.setStatusBar(self.statusBar)
        self.statusBar.showMessage(self._versionInfo.brief)
    
    def setLineCount(self, n: int):
        lbl = self.findLineCountLabel()
        if lbl is None:
            pass
        else:
            lbl.setText(f"Line Count={n}")
            
    def findLineCountLabel(self):
        widget = self.findChild(QLabel, LBL_LINE_COUNT)
        assert widget is not None, f"Programmer error: widget {LBL_LINE_COUNT} not found"
        return widget
        
    def setEllipseCount(self, n: int):
        lbl = self.findEllipseCountLabel()
        if lbl is None:
            pass
        else:
            lbl.setText(f"Ellipse Count={n}")
            
    def findEllipseCountLabel(self):
        widget = self.findChild(QLabel, LBL_ELLIPSE_COUNT)
        assert widget is not None, f"Programmer error: widget {LBL_ELLIPSE_COUNT} not found"
        return widget
        
    def helpDocCall(self):
        ''' Open a web browser tab
        
        'new=2' means open in new browser tab. '''
        page = 'PyQt-HelloWorld4.htm'
        webbrowser.open(f'https://la-solutions.org/CONNECT/Python/{page}', new=2)
        self.statusBar.showMessage(f'Browser displays web page {page}')

    def exitCall(self):
        MessageCenter.ShowDebugMessage("Exit", "Exit this app", False)
        self.close()
        
    def count_ellipses_imp(self):
        ''' Implementation of menu action Count Ellipses. '''
        msg = "count_ellipses_imp"
        MessageCenter.ShowDebugMessage(msg, msg, False)
        self.statusBar.showMessage('Count Ellipses')
        # Call function in count_elements_by_type.py
        counter = DgnElementCounter()
        nEllipses = counter.CountEllipses()
        msg = f"Found {nEllipses} ellipses"
        MessageCenter.ShowInfoMessage(msg, msg, False)
        self.setEllipseCount(nEllipses)
        
    def count_lines_imp(self):
        ''' Implementation of menu action Count Lines. '''
        msg = "count_lines_imp"
        MessageCenter.ShowDebugMessage(msg, msg, False)
        self.statusBar.showMessage('Count Lines')
        # Call function in count_elements_by_type.py
        counter = DgnElementCounter()
        nLines = counter.CountLines()
        msg = f"Found {nLines} lines"
        MessageCenter.ShowInfoMessage(msg, msg, False)
        self.setLineCount(nLines)
     
def Run(app: QApplication, vinfo: VersionInfo):
    ''' Call Run() from your app's main(). '''
    w = MainWindow(vinfo)
    w.show()
    ''' Set up and start the message pump timer. '''
    w.start_message_pump_timer()
    assert app is not None, "Run: programmer error"
    app.exec()  # run the application's event loop until the window is closed
    
if __name__ == "__main__":  # check if this script is being run directly (not imported as a module)
    app = QApplication.instance()   # get the existing application instance, if any
    
    if app is None:  # check if no application instance exists
        app = QApplication(sys.argv)   # create a new application instance with command-line arguments    
    vinfo = VersionInfo("Hello World 4", 25, 4, 21, "Demonstrates a PyQt Menu")
    Run(app, vinfo)
