# -*- coding: utf-8 -*-

'''
Place cells along line.

User should pick a line to follow, using the Pick button.
Clicking the Execute button places a named cell at specified intervals along that line.

Created 06-Aug-2025
This example is a Python version of the VBA Create Centre Line macro,
with the addition of a user interface.
https://www.la-solutions.org/CONNECT/MVBA/MVBA-CreateCentreLine.htm

'''
import os

from MSPyBentley import *
from MSPyDgnPlatform import *    
from MSPyMstnPlatform import *
from CreateCentreLine.place_centre_line_qt import *
from la_solutions.version_info import VersionInfo
#import CreateCentreLine.commands
from CreateCentreLine.commands import *

def Version ():
    ''' Return the version of this app. '''
    return VersionInfo("Create Centre Line", 25, 9, 14, "Pick two lines then create a new line between them")

PROJECT_DIR = 'CreateCentreLine'
# Main entry point for the Create Centre Line app

if __name__ == "__main__":
    vinfo = Version() 
    MessageCenter.ShowInfoMessage(vinfo.brief, vinfo.verbose, False)
    # Start our user interface
    Window.Run(vinfo, os.path.dirname(__file__), PROJECT_DIR)
    