import sys
import os
from pathlib import Path
from MSPyMstnPlatform import MessageCenter

def get_script_folder ()->str:
    """Get the folder that contains this Python script"""
    path = os.path.dirname(__file__)
    #print(f"path '{path}'")
    #print(f"get_script_folder '{os.path.join(path)}'")
    return os.path.join(path)

def get_file_from_sibling_folder (file_name: str, subFolder: str)->str:   
    """Get a fully-qualified file path for a file in a sibling folder of this script's folder"""
    #project_folder = Path(get_script_folder()).parent
    project_folder = os.getcwd()
    #print(f"get_file_from_sibling_folder project_folder '{project_folder}'")
    subFolderPath = os.path.abspath(os.path.join(project_folder, subFolder))
    file_path = os.path.join(subFolderPath, file_name)
    #msg = f"get_file_from_sibling_folder file_name '{file_name}' "
    #print(msg)
    #MessageCenter.ShowDebugMessage(msg, file_path, False)
    if os.path.isfile(file_path):
        #msg = f"Found file '{file_path}'"
        #MessageCenter.ShowDebugMessage(msg, file_path, False)
        return file_path
    else:
        #   Advise user that the file name is incorrect
        brief = f"File '{file_name}' does not exist"
        verbose = f"File '{file_path}' does not exist"
        #   These messages are displayed in MicroStation's Message Center
        MessageCenter.ShowErrorMessage (brief, verbose, False)
        return str()   
    
def get_file_from_script_folder (file_name: str)->str:
    """Get a fully-qualified file path for a file in this script's folder"""
    file_path = os.path.join(get_script_folder(), file_name)
    #msg = f"get_file_from_script_folder file_name '{file_name}' "
    #print(msg)
    #MessageCenter.ShowDebugMessage(msg, file_path, False)
    if os.path.isfile(file_path):
        msg = f"Found file '{file_path}'"
        print(msg)
        #MessageCenter.ShowDebugMessage(msg, file_path, False)
        return file_path
    else:
        #   Advise user that the file name is incorrect
        brief = f"File '{file_name}' does not exist"
        verbose = f"File '{file_path}' does not exist"
        #   These messages are displayed in MicroStation's Message Center
        MessageCenter.ShowErrorMessage (brief, verbose, False)
        return str()   
        
def get_icon_from_script_sub_folder (file_name: str)->str:
    """Get a fully-qualified file path for a file in this script's Icons sub-folder."""
    #print(f"get_icon_from_script_sub_folder script folder '{get_script_folder()}'")
    file_path = os.path.join(get_script_folder(), "Icons", file_name)
    #print(f"get_icon_from_script_sub_folder file_path '{file_path}'")
    if os.path.isfile(file_path):
        return file_path
    else:
        #   Advise user that the file name is incorrect
        brief = f"Icon '{file_name}' does not exist"
        verbose = f"Icon '{file_path}' does not exist"
        #   These messages are displayed in MicroStation's Message Center
        MessageCenter.ShowErrorMessage (brief, verbose, False)
        return str()   

def get_icon_from_root_sub_folder (root_path: str, file_name: str)->str:
    """Get a fully-qualified file path for a file in this script's Icons sub-folder."""
    #print(f"get_icon_from_root_sub_folder script folder '{root_path}'")
    file_path = os.path.join(root_path, "Icons", file_name)
    #print(f"get_icon_from_script_sub_folder file_path '{file_path}'")
    if os.path.isfile(file_path):
        return file_path
    else:
        #   Advise user that the file name is incorrect
        brief = f"Icon '{file_name}' does not exist"
        verbose = f"Icon '{file_path}' does not exist"
        #   These messages are displayed in MicroStation's Message Center
        MessageCenter.ShowErrorMessage (brief, verbose, False)
        return str()   
