import importlib
from PyQt5.QtGui import QWindow

def import_function(mod_name: str, func_name: str):
    ''' Import the specified module then import a function contained in that module. '''
    try:
        module = importlib.import_module(mod_name, "CreateCentreLine")
        print(f"import_function importlib.import_module({mod_name}) OK")
        try:   
            f = getattr(module, func_name)
            print(f"getattr({func_name}) = '{f}'")
            return f
        except Exception as err:
            msg = f"import_function({mod_name}, {func_name}): Unexpected {err=}, {type(err)=}"
            print (msg)
    except Exception as err:
        msg = f"import_function: importlib.import_module({mod_name}) Unexpected {err=}, {type(err)=}"
        print (msg)
    return None
    
def invoke_function(mod_name: str, func_name: str, window: QWindow):
    ''' Call the named function that is defined in the named module e.g. FollowLine.cmd_pick_line.
    
        module = importlib.import_module(mod_name) successfully gets a reference to that named module.
        To inspect that module, use getattr(module, nested-module name) e.g. c1 = getattr(module, "cmd_pick_line").
        If window is valid, then that's the UI that called this function.
    '''
    if not mod_name:
        # Assume function is in current file
        func_name(window)
    else:
        command_function = import_function(mod_name, func_name)
        if command_function:
            print(f"Invoking {mod_name}:{func_name}")
            command_function(window)
        else:
            print(f"Unable to invoke {mod_name}:{func_name}")
