# -*- coding: utf-8 -*-

'''
Created 10-Mar-2025
This example is a Python version of the VBA Create Centre Line macro,
with the addition of a user interface.
'''
from MSPyBentley import *
from MSPyMstnPlatform import *
from enum import StrEnum
from PyQt5.QtGui import QWindow

from la_solutions_create_centre_line import Version
from la_solutions.file_utilities import *
from CreateCentreLine.cmd_pick_line import *
from CreateCentreLine.cmd_execute import *

''' MicroStation key-in commands are not used because of the clash between QtPy and MicroStation messaging.''' 

def cmdPickLine1(w: QWindow = None):
    '''Called by main Window._requests.'''
    cmdName = "cmdPickLine1"
    MessageCenter.ShowDebugMessage(cmdName, f"{cmdName}  ", False) 
    LINE_NUMBER = 1
    cmdPickLineElement.InstallNewInstance(LINE_NUMBER, w)
    
def cmdPickLine2(w: QWindow = None):
    '''Called by main Window._requests.'''
    cmdName = "cmdPickLine2"
    MessageCenter.ShowDebugMessage(cmdName, f"{cmdName} ", False) 
    LINE_NUMBER = 2
    cmdPickLineElement.InstallNewInstance(LINE_NUMBER, w)
    
def cmdExecute(w: QWindow = None):
    ''' Called by main Window._requests.'''
    cmdName = "cmdExecute"
    executor = create_centre_line(w)
    num_chords = executor.execute()
    #MessageCenter.ShowDebugMessage(cmdName, "Execute place cells along line", False)
    #MessageCenter.ShowDebugMessage(cmdName, f"{cmdName}  ", False)    

def cmdFileExit(w: QWindow = None):
    ''' Called by main Window._requests.'''
    cmdName = "cmdFileExit"
    MessageCenter.ShowDebugMessage(cmdName, "Exit the application", False)

def cmdHelpAbout(w: QWindow = None):
    ''' Called by main Window._requests.'''
    cmdName = "cmdHelpAbout"
    vinfo = Version()
    MessageCenter.ShowInfoMessage(f"About {vinfo.brief}", vinfo.verbose, False)
    MessageCenter.ShowDebugMessage(cmdName, f"{cmdName} shows brief version info ", False)    

def cmdHelpDoc(w: QWindow = None):
    ''' Called by main Window._requests.'''
    cmdName = "cmdHelpDoc"
    MessageCenter.ShowInfoMessage(cmdName, "Create Centre Line line on-line help", False)
    msg = f"{cmdName} opens a web page in your browser "
    MessageCenter.ShowDebugMessage(cmdName, msg, False) 
    print(msg)
    _PAGE = 'Python-CreateCentreLine.htm'
    _OPEN_NEW_BROWSER_TAB = 2
    web_page = f'https://www.la-solutions.org/CONNECT/Python/{_PAGE}'
    print(web_page)
    import webbrowser
    webbrowser.open(web_page, new=_OPEN_NEW_BROWSER_TAB)
    
if __name__ == "__main__":  # check if this script is being run directly (not imported as a module)
    MessageCenter.ShowDebugMessage("commands ", f"{WString (__file__)} ", False)
    cmdHelpDoc()
    
