from PyQt5.QtGui import QWindow
from .import_invoke_function import import_function, invoke_function

class CommandRequests():
    '''
    A class that helps manage command requests in an app. that uses a Qt or TkInter UI.
    This class helps to isolate command function calls from the UI menu or button that invokes it.
    Its raison d'être is the need to avoid putting MicroStation function calls in the UI code.
    '''
    def __init__(self, requests: dict[[str, str], bool]):
        # A dictionary of tuple(module name, function name) and requested flag      
        self._requests = requests

    def __str__(self):
        c_list = 'CommandRequests(\n'
        for (n, key) in enumerate(self._requests, start = 1):
            want_return = n < len(self._requests)
            (mod, func) = key
            c_list += f"  [{n}] module '{mod}' function '{func}' requested {self._requests[key]}"
            if want_return:
                c_list += "\n"
        c_list += ")"            
        return c_list
        
    def clear_requests(self):
        for key in self._requests:
            self._requests[key] = False
    
    def is_requested(self, name)->bool:
        for key in self._requests:
           (_, func) = key
           if name == func and self._requests[key]:
               return True
        return False

    def have_request(self)->[[str, str], bool]:
        #print("CommandRequests.have_request()")
        for key in self._requests:
            (mod_name, func) = key
            if self._requests[key]:
                print(f"have_request '{func}'='{self._requests[key]}'")
                return ((mod_name, func), True)
        return ((None, None), False)

    def invoke_requested(self, w: QWindow = None):
        print("CommandRequests.invoke_requested()")
        for key in self._requests:
            (mod_name, func) = key
            if self._requests[key]:
                invoke_function(mod_name, func, w)
        
    def set_requested(self, name):
        self.clear_requests()
        for key in self._requests:
            (_, func) = key
            if name == func:
                self._requests[key] = True
        
    def get_function(self, name)->[str, str]:
        for key in self._requests:
            (mod_name, func) = key
            print(f"module '{mod_name}' function '{func}' flag '{self._requests[key]}'")
            if name == func:
                return (mod_name, func)
        return (None, None)
        
if __name__ == "__main__":  # check if this script is being run directly (not imported as a module)
    CMD1 = "cmd1"
    CMD2 = "cmd2"
    MODULE1 = "mod1"
    MODULE2 = "mod2"
    commands = {(MODULE1, CMD1): False, (MODULE2, CMD2): False}
    print(commands) 
    requests = CommandRequests(commands)
    print("+++1 requests")
    print(requests)

    (module, func) = requests.get_function(CMD1)
    print (f"Module '{module}' Function '{func}'")

    name = CMD1
    requests.set_requested(name)
    r = requests.is_requested(name)
    if r:
        print(f"{name} is requested")
    else:
        print(f"{name} is not requested")

    ((mod, cmd), flag) = requests.have_request()
    if flag:
        print(f"requested {mod}.{cmd}")
    else:
        print("No request active")

    name = CMD2
    requests.set_requested(name)
    r = requests.is_requested(name)
    if r:
        print(f"{name} is requested")
    else:
        print(f"{name} is not requested")

    ((mod, cmd), flag) = requests.have_request()
    if flag:
        print(f"requested {mod}.{cmd}")
    else:
        print("No request active")

    print("***************")
    requests.clear_requests()
    name = CMD1
    r = requests.is_requested(name)
    if r:
        print(f"{name} is requested")
    else:
        print(f"{name} is not requested")

    ((mod, cmd), flag) = requests.have_request()
    if flag:
        print(f"requested {mod}.{cmd}")
    else:
        print("No request active")
    print("***************")        