# -*- coding: utf-8 -*-

'''
Created 26-Feb-2025
Test framework for Bentley Python BeFileName
'''
import os.path
from pathlib import Path
from MSPyBentley import BeFileName, WString
from MSPyMstnPlatform import MessageCenter, ISessionMgr   
from MSPyDgnPlatform import *
from la_solutions.version_info import VersionInfo

def Version():
    ''' Return the version of this app. '''
    return VersionInfo("BeFileName Test", 25, 2, 27, "Test and demonstrate the features of BeFileName")

if __name__ == "__main__":  # check if this script is being run directly (not imported as a module)
    vinfo = Version()
    MessageCenter.ShowInfoMessage(vinfo.brief, vinfo.verbose, False) 

    dev = WString()
    fullDir = WString()
    name = WString()
    ext = WString()
    dgnFile = ISessionMgr.GetActiveDgnFile()
    beFileName = BeFileName(str(dgnFile.GetFileName()))
    try:
        msg = f"BeFileName implements magic method __str__ '{beFileName}'"
        MessageCenter.ShowInfoMessage(msg, beFileName.GetWCharCP(), False)
    except:
        msg = f"BeFileName doesn't implement __str__ "
        MessageCenter.ShowErrorMessage(msg, msg, False)
    
    # Split a full file name into device, path, name and extension
    beFileName.ParseName(dev, fullDir, name, ext)
    msg = f"Parsed '{dev}' '{fullDir}' '{name}' '{ext}' "
    MessageCenter.ShowInfoMessage(msg, str(ISessionMgr.ActiveDgnFile.GetFileName()), False)
    # Abbreviate the file name in-place
    #abbreviated = BeFileName(beFileName.GetWCharCP())
    abbreviated = BeFileName(str(beFileName))
    MAX_LENGTH = 20
    abbreviated.Abbreviate (MAX_LENGTH)
    msg = f"Abbreviated '{abbreviated.GetWCharCP()}'"
    MessageCenter.ShowInfoMessage(msg, msg, False)
    # Extract the components of the file name
    beFileName.ParseName(dev, fullDir, name, ext)
    # Substitute a new file name
    newName = "another"
    beFileName.BuildName(str(dev), str(fullDir), newName, str(ext))     
    msg = f"Replaced name: '{beFileName}'"
    MessageCenter.ShowInfoMessage(msg, str(beFileName), False)    
    # Substitute a new extension
    newExtension = "xlsx"
    beFileName.BuildName(str(dev), str(fullDir), newName, newExtension)
    msg = f"Replaced extension: '{beFileName.GetWCharCP()}'"
    MessageCenter.ShowInfoMessage(msg, beFileName.GetWCharCP(), False)
    # Test whether a file exists
    # BeFileName.DoesPathExist() is a class method
    if BeFileName.DoesPathExist(beFileName.GetWCharCP()):
        msg = f"File exists"
        MessageCenter.ShowInfoMessage(msg, beFileName.GetWCharCP(), False)
    else:
        msg = f"File does not exist"
        MessageCenter.ShowErrorMessage(msg, beFileName.GetWCharCP(), False)
        
    dgnFile = str(dgnFile.GetFileName())
    # BeFileName.DoesPathExist() is a class method
    if BeFileName.DoesPathExist(dgnFile):
        msg = f"File exists"
        MessageCenter.ShowInfoMessage(msg, dgnFile, False)
    else:
        msg = f"File does not exist"
        MessageCenter.ShowErrorMessage(msg, dgnFile, False) 
    # BeFileName.DoesPathExist() is a class method
    validPath = r"\\Asterix\DataDir\Bentley\CONNECT\LA Solutions\WorkSets\Python"
    invalidPath = r"\\NoServer\DataDir\Bentley\CONNECT\ "
    if BeFileName.DoesPathExist(invalidPath):
        msg = f"Path exists"
        MessageCenter.ShowInfoMessage(msg, invalidPath, False)
    else:
        msg = f"Path does not exist"
        MessageCenter.ShowErrorMessage(msg, invalidPath, False)        
    # Test whether a string represents a directory.
    # This is a class method.
    if BeFileName.IsDirectory(validPath):
        msg = f"Path is a directory"
        MessageCenter.ShowInfoMessage(msg, validPath, False)
    else:
        msg = f"Path is not a directory"
        MessageCenter.ShowErrorMessage(msg, validPath, False)        
    # Get a temporary file name.
    tempPath = BeFileName()
    BeFileName.BeGetTempPath(tempPath)
    msg = f"Temp path '{tempPath.GetWCharCP()}'"
    MessageCenter.ShowInfoMessage(msg, tempPath.GetWCharCP(), False)
    tempFile = BeFileName()
    BeFileName.BeGetTempFileName(tempFile, tempPath, "")
    msg = f"Temp file '{tempFile.GetWCharCP()}'"
    MessageCenter.ShowInfoMessage(msg, tempFile.GetWCharCP(), False)
    